/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import net.skinsrestorer.shadow.mariadb.client.Column;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;

public class ByteArrayCodec
implements Codec<byte[]> {
    public static final byte[] BINARY_PREFIX = new byte[]{95, 98, 105, 110, 97, 114, 121, 32, 39};
    public static final ByteArrayCodec INSTANCE = new ByteArrayCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BLOB, new DataType[]{DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.BIT, DataType.GEOMETRY, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING});

    @Override
    public String className() {
        return "byte[]";
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Byte.TYPE && type.isArray() || type.isAssignableFrom(byte[].class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof byte[];
    }

    @Override
    public byte[] decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        return this.getBytes(buf, length, column);
    }

    private byte[] getBytes(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case BIT: 
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case STRING: 
            case VARSTRING: 
            case VARCHAR: 
            case GEOMETRY: {
                byte[] arr = new byte[length];
                buf.readBytes(arr);
                return arr;
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as byte[]", new Object[]{column.getType()}));
    }

    @Override
    public byte[] decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        return this.getBytes(buf, length, column);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        int length = ((byte[])value).length;
        encoder.writeBytes(BINARY_PREFIX);
        encoder.writeBytesEscaped((byte[])value, maxLength == null ? length : Math.min(length, maxLength.intValue()), (context.getServerStatus() & 0x200) != 0);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        int length = ((byte[])value).length;
        if (maxLength != null) {
            length = Math.min(length, maxLength.intValue());
        }
        encoder.writeLength(length);
        encoder.writeBytes((byte[])value, 0, length);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

